package jcircus.environment;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import jcircus.exceptions.ChanDefOtherChanSyncException;
import jcircus.exceptions.ChanDefOtherChanUseException;
import jcircus.exceptions.ChanSyncUnificationException;
import jcircus.exceptions.ChanUseUnificationException;

import jcircus.exceptions.ChannelNotDefinedExceptionForProcess;
import jcircus.exceptions.DifferentCardinalitiesException;
import jcircus.exceptions.MoreThanOneWriterException;
import jcircus.exceptions.NotYetImplementedException;
import jcircus.util.CircusType;
import jcircus.util.ChanUse;
import jcircus.util.NameType;
import jcircus.util.ChanSync;
import jcircus.util.Util;
import net.sourceforge.czt.z.ast.DeclName;
import net.sourceforge.czt.z.util.Factory;

/**
 * ProcChanEnv.java
 *
 * @author Angela Freitas
 *
 */
public class ProcChanEnv {
    
    private ChanInfoEnv chanInfoEnv_;
    private ChanUseEnv chanUseEnvVis_;
    private ChanUseEnv chanUseEnvHid_;
    private ChanSyncEnv chanSyncEnv_;
    private NameTypeEnv nameTypeEnv_;

    private Factory factory_;
    private boolean isBasicProcess_;
    
    /**
     * Constructor.
     *
     */
    public ProcChanEnv() {
        
        this.chanInfoEnv_ = new ChanInfoEnv();
        this.chanUseEnvVis_ = new ChanUseEnv();
        this.chanUseEnvHid_ = new ChanUseEnv();
        this.chanSyncEnv_ = new ChanSyncEnv();
        this.nameTypeEnv_ = new NameTypeEnv();
        this.factory_ = new Factory();
        this.isBasicProcess_ = false;
    }
    
    /**
     * 
     * @param chanUseEnvVis
     * @param chanUseEnvHid
     * @param chanSyncEnv
     * @param nameTypeEnv
     */
    private ProcChanEnv(
            ChanInfoEnv chanInfoEnv,
            ChanUseEnv chanUseEnvVis,
            ChanUseEnv chanUseEnvHid,
            ChanSyncEnv chanSyncEnv,
            NameTypeEnv nameTypeEnv) {
        
        this.chanInfoEnv_ = chanInfoEnv;
        this.chanUseEnvVis_ = chanUseEnvVis;
        this.chanUseEnvHid_ = chanUseEnvHid;
        this.chanSyncEnv_ = chanSyncEnv;
        this.nameTypeEnv_ = nameTypeEnv;
        this.factory_ = new Factory();
        this.isBasicProcess_ = false;
    }
    
    /**
     *
     */
    public ChanInfoEnv getChanInfoEnv() {
        return this.chanInfoEnv_;
    }
    
    /**
     *
     */
    public void setChanInfoEnv(ChanInfoEnv chanInfoEnv) {
        this.chanInfoEnv_ = chanInfoEnv;
    }
    
    /**
     *
     * @return
     */
    public ChanUseEnv getChanUseEnvVis() {
        return this.chanUseEnvVis_;
    }
    
    /**
     *
     * @return
     */
    public ChanUseEnv getChanUseEnvHid() {
        return this.chanUseEnvHid_;
    }
    
    /**
     *
     * @return
     */
    public ChanSyncEnv getChanSyncEnv() {
        return this.chanSyncEnv_;
    }
    
    /**
     *
     * @return
     */
    public NameTypeEnv getNameTypeEnv() {
        return this.nameTypeEnv_;
    }
    
    /**
     * 
     * @param channelName
     * @param chanUse
     * @throws InvalidFormatException
     */
    public void includeVisible(String channelName, 
            ChanUse chanUse, ChanSync chanSync, CircusType circusType) 
                throws ChanDefOtherChanUseException, ChanDefOtherChanSyncException{
        
        ChanUse chanUseInEnv;
        ChanSync chanSyncInEnv;
        
        if (chanUseEnvVis_.containsKey(channelName)) {
            chanUseInEnv = chanUseEnvVis_.get(channelName);

            if (!chanUseInEnv.equals(chanUse)) {
                throw new ChanDefOtherChanUseException(channelName, 
                        chanUseInEnv, chanUse);
            }
        }
        
        // Insert as visible
        this.chanUseEnvVis_.put(channelName, chanUse);
        
/**
 *
 * This treatment for hidden is not necessary anymore because hiding will only occur
 * as the last operator in a process definition.
 *        
        // Check if the channel has been previously hidden - in this case it is not
        // hidden anymore
        if (this.chanUseEnvHid_.containsKey(channelName)) {
            this.chanUseEnvHid_.remove(channelName);
        }
*/        
        
        if (chanSyncEnv_.containsKey(channelName)) {
            chanSyncInEnv = chanSyncEnv_.get(channelName);

            if (!chanSyncInEnv.equals(chanSync)) {
                throw new ChanDefOtherChanSyncException(channelName, 
                        chanSyncInEnv, chanSync);
            }
        }        
        this.chanSyncEnv_.put(channelName.toString(), chanSync);
        
        // Includes the channel in the type environment
        DeclName name = this.factory_.createDeclName(channelName); //new DeclName(channelName);
        Util.addNameTypeAnn(name, NameType.Channel);
        this.nameTypeEnv_.put(name, circusType);
    }
    
    /**
     * Merges two process channel environments, by unifying the two sets of channels
     * visible and hidden.
     * However, if a channel appears in the visible set of any of the environments, it will
     * not appear in the hidden set of the resulting environment.
     * 
     * @param procChanEnv
     * @return
     */
    public ProcChanEnv merge(ProcChanEnv procChanEnv, boolean isParallel) 
            throws MoreThanOneWriterException, ChanUseUnificationException,
                DifferentCardinalitiesException, ChanSyncUnificationException {
    
        
        ProcChanEnv r = new ProcChanEnv();
        
        ChanUseEnv newChanUseEnvVis;
        ChanUseEnv newChanUseEnvHid;
        ChanSyncEnv newChanSyncEnv;
        NameTypeEnv newTypeEnvironment;
        ChanInfoEnv newChanInfoEnv;
        
        // visible
        // Obs: I am not treating compatibility here.
        newChanUseEnvVis = new ChanUseEnv();
        newChanUseEnvVis = this.chanUseEnvVis_.merge(
                procChanEnv.getChanUseEnvVis(), isParallel);

/*      
 * This treatment for hidden is not necessary anymore because hiding will only occur
 * as the last operator in a process definition.
 *  
        // hidden
        newChanUseEnvHid = new ChanUseEnv();
        newChanUseEnvHid.putAll(this.chanUseEnvHid_);
        newChanUseEnvHid.putAll(procChanEnv.getChanUseEnvHid());
        // Removes the visible channels from the resulting channel
        newChanUseEnvHid.removeAll(this.chanUseEnvVis_);
        newChanUseEnvHid.removeAll(procChanEnv.getChanUseEnvVis());
*/
        
        // channel sync
        newChanSyncEnv = new ChanSyncEnv();
        newChanSyncEnv = this.chanSyncEnv_.merge(
                procChanEnv.getChanSyncEnv());
        
        // type env
        newTypeEnvironment = new NameTypeEnv();
        newTypeEnvironment.putAll(this.nameTypeEnv_);
        newTypeEnvironment.putAll(procChanEnv.getNameTypeEnv());

        // channel ms
        newChanInfoEnv = this.chanInfoEnv_.merge(
                procChanEnv.chanInfoEnv_, isParallel);
        
        r = new ProcChanEnv(
                newChanInfoEnv, 
                newChanUseEnvVis,
                new ChanUseEnv(),
                newChanSyncEnv,
                newTypeEnvironment);
        
        return r;
    }
    
    /**
     *
     * @param newChannels
     * @param oldChannels
     */
    public ProcChanEnv substitute(List newChannels, List oldChannels) {
        
        ProcChanEnv r;
        
        ChanInfoEnv newChanInfoEnv = this.chanInfoEnv_.substitute(newChannels, oldChannels);
        
        ChanUseEnv newChanUseEnv =
                this.chanUseEnvVis_.substitute(newChannels, oldChannels);
/**
 *
 *        
 * This treatment for hidden is not necessary anymore because hiding will only occur
 * as the last operator in a process definition.
 *
        ChanUseEnv newChannelUseEnvironmentHidden =
                this.chanUseEnvHid_.substitute(newChannels, oldChannels);
*/        
        ChanSyncEnv newChanSyncEnv =
                this.chanSyncEnv_.substitute(newChannels, oldChannels);
        
        NameTypeEnv newNameTypeEnv =
                this.nameTypeEnv_.substitute(newChannels, oldChannels);
        
        r = new ProcChanEnv(
                newChanInfoEnv,
                newChanUseEnv,
                new ChanUseEnv(),
                newChanSyncEnv,
                newNameTypeEnv
                );
        
        return r;
    }
    
    /**
     * Returns a new environment.
     *
     * @param hashSet
     */
    public ProcChanEnv hide(HashSet hashSet) {
        
        ProcChanEnv r;
        
        Iterator it = hashSet.iterator();
        
        ChanUseEnv newChanUseEnvVis = new ChanUseEnv();
        ChanUseEnv newChanUseEnvHid = new ChanUseEnv();
        //ChanInfoEnv newChanInfoEnv = new ChanInfoEnv(); 
        
        Iterator iteratorVisible;
        String channelName;
        ChanUse javaTypeChannel;
        
        iteratorVisible = this.chanUseEnvVis_.iteratorKeys();
        
        while(iteratorVisible.hasNext()) {
            channelName = (String) iteratorVisible.next();
            javaTypeChannel = this.chanUseEnvVis_.get(channelName);
            
            if (hashSet.contains(channelName)) {
                newChanUseEnvHid.put(channelName, javaTypeChannel);
            } else {
                newChanUseEnvVis.put(channelName, javaTypeChannel);
            }
            
        }
        
        // Creates a new env
        r = new ProcChanEnv(
                this.chanInfoEnv_, 
                newChanUseEnvVis,
                newChanUseEnvHid,
                this.chanSyncEnv_,
                this.nameTypeEnv_);
        
        return r;
    }
    
    /**
     *
     * @param channelName
     * @return
     * @throws Exception
     */
    public ChanUse getJavaChannelType(String channelName) throws ChannelNotDefinedExceptionForProcess {
        
        ChanUse r;
        
        if (this.chanUseEnvHid_.containsKey(channelName)) {
            r = this.chanUseEnvHid_.get(channelName);
        } else if (this.chanUseEnvVis_.containsKey(channelName)) {
            r = this.chanUseEnvVis_.get(channelName);
        } else
            throw new ChannelNotDefinedExceptionForProcess(channelName);
        
        return r;
    }
    
    /**
     * Transforms the ChanUseEnv visible into an ProcChanUseEnv
     * This is called only at visitProcessPara, if its process is a basicProcess.
     *
     * This will have to be called at the visiting method for all subclasses
     * of CircusProcess, and will passa process ID instead.
     * 
     */
    public void transform(Integer id) {
        
        // Only visible channels have been defined at this moment (since the process
        // in question is a basic process)
        Iterator itVisible = chanUseEnvVis_.iteratorKeys();
        
        String channelName;
        ChanUse chanUse;
        
        // For each channel
        while (itVisible.hasNext()) {
            channelName = (String) itVisible.next();
            chanUse = chanUseEnvVis_.get(channelName);
            
            // Creates a ProcChanUseEnv object with cardinality 1
            ProcChanUseEnv procChanUseEnv = new ProcChanUseEnv(1);
            procChanUseEnv.put(id, chanUse);
            
            // Inserts it into chanInfoEnv
            chanInfoEnv_.put(channelName, procChanUseEnv);
        }
    }
        
    /**
     *
     */
    public ProcChanEnv replaceIdInChanInfoEnv(Integer newId) {
        
        ProcChanEnv r;
        
        r = new ProcChanEnv(
                this.chanInfoEnv_.replaceId(newId), 
                this.chanUseEnvVis_,
                new ChanUseEnv(),
                this.chanSyncEnv_,
                this.nameTypeEnv_);
        
        return r;
    }
    
    public boolean isBasicProcess() {
        return this.isBasicProcess_;
    }
    
    public void setBasicProcess() {
        this.isBasicProcess_ = true;
    }
    
}
